<?php $__env->startSection('title'); ?> Recharge Reports <?php $__env->stopSection(); ?>

<?php $__env->startSection('css'); ?>

<!--datatable css-->

<link href="https://cdn.datatables.net/1.11.5/css/dataTables.bootstrap5.min.css" rel="stylesheet" type="text/css" />

<!--datatable responsive css-->

<link href="https://cdn.datatables.net/responsive/2.2.9/css/responsive.bootstrap.min.css" rel="stylesheet" type="text/css" />

<link href="https://cdn.datatables.net/buttons/2.2.2/css/buttons.dataTables.min.css" rel="stylesheet" type="text/css" />

<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<?php $__env->startComponent('components.breadcrumb'); ?>

<?php $__env->slot('li_1'); ?> User Reports <?php $__env->endSlot(); ?>

<?php $__env->slot('title'); ?>Recharge Reports <?php $__env->endSlot(); ?>

<?php echo $__env->renderComponent(); ?>



<div class="row">

    <div class="col-lg-12">

        <div class="card">

            <div class="card-header align-items-center d-flex">

                <h4 class="card-title mb-0 flex-grow-1">Search</h4>

                <div class="flex-shrink-0">

                </div>

            </div>

            <div class="card-body">

                <form action="#">

                    <div class="row gy-3">

                        

                        <div class="col-lg-2">

                            <div>

                                <label class="form-label mb-0">From Date</label>

                                <input type="date" class="form-control" name="from_date" value="<?php echo e(\Carbon\Carbon::today()->format('Y-m-d')); ?>" id="from_date">

                            </div>

                        </div>

                        <div class="col-lg-2">

                            <div>

                                <label class="form-label mb-0">To Date </label>

                                <input type="date" class="form-control" name="to_date" value="<?php echo e(\Carbon\Carbon::today()->format('Y-m-d')); ?>"id="to_date">

                            </div>  

                        </div>

                        <div class="col-lg-2">

                            <label class="form-label mb-0">Services</label>

                            <select class="form-select mb-3" name="service_id"  id="service_id">

                                <option selected value="0">All</option>

                                <option value="1">MOBILE</option>

                                <option value="2">DTH</option>

                                <option value="4">POSTPAID</option>

                                <!-- <option value="14">GOOGLE PLAY</option> -->

                            </select>

                        </div>

                        <div class="col-lg-2">

                            <label class="form-label mb-0">Providers</label>

                            <select class="form-select mb-3" name="provider_id"  id="provider_id">

                                <option selected value="0">All</option>

                               

                            </select>

                        </div>



                        <div class="col-lg-2">

                            <label class="form-label mb-0">Status </label>

                            <select class="form-select mb-3" name="status_name"  id="status_name">

                                <option selected value="All">All</option>

                                <option value="Success">Success</option>

                                <option value="Pending">Pending</option>

                                <option value="Failed">Failed</option>

                                <option value="Refunded">Refunded</option>

                                <option value="Under Proces">Under Proces</option>

                            </select>

                        </div>

                        <div class="col-lg-2">

                            <label class="form-label mb-0">Apis</label>

                            <select class="form-select mb-3" name="api_id"  id="api_id">

                                <option selected value="0">All</option>

                            </select>

                        </div>

                        

                        <div class="col-lg-3">

                            <div>

                                <label class="form-label mb-0">Order Id</label>

                                <input type="text" class="form-control" placeholder="Enter Order Id" name="order_id" value="" id="order_id">

                            </div>

                        </div>

                        <div class="col-lg-3">

                            <div>

                                <label class="form-label mb-0">Mobile/DTH Number</label>

                                <input type="number" class="form-control" placeholder="Enter Number" name="number_text" value="" id="number_text">

                            </div>

                        </div>

                        <div class="col-lg-3">

                            <input type="hidden" name="id_value" id="id_value" value="0">

                            <div>

                                <label class="form-label mb-0">User Search</label>

                                <input type="text" class="form-control" name="user_id" value="" id="user_id">

                                <div id="user_list">

                                    

                                </div>

                            </div>

                        </div>

                        

                        <div class="col-lg-1">

                            <label class="form-label mb-0">Type </label>

                            <select class="form-select mb-3" name="tbl_type"  id="tbl_type">

                                <option selected value="0">Current </option>

                                <option value="1">Backup</option>

                            </select>

                        </div>


                        <div class="col-lg-1">

                            <label class="form-label mb-0">Complaints </label>

                            <select class="form-select mb-3" name="complaint_id"  id="complaint_id">

                                <option selected value="0">All</option>
                                <option value="1">Yes</option>

                            </select>

                        </div>

                        <div class="col-lg-1">

                            <div>

                                <label class="form-label mb-0"></label>

                                <button type="button" id="search_btn" class="form-control btn btn-secondary bg-gradient waves-effect waves-light" onclick="fetchAllSearch(1,10)">Search</button>

                            </div>  

                        </div>

                    </div>                          

                </form>

            </div>

        </div>

    </div>

</div>



<div class="row">

    <div class="col-lg-12">

        <div class="card">

            <div class="card-header align-items-center d-flex">

                <h4 class="card-title mb-0 flex-grow-1">Recharge Reports List</h4>

                <div class="flex-shrink-0">
                    <div class="form-check form-switch form-switch-right form-switch-md">
                        <button type="button" id="export_btn" class="btn btn-info waves-effect waves-light" onclick="exportExcel()">Export Excel</button>
                    </div>
                </div>

            </div>

            <div class="card-body" id="list_result">

                <h4 class="text-center text-secondary my-3">No record found</h4>

            </div>

        </div>

    </div>

</div>





   <!-- Complaint Details Modals -->

   <div id="complaintModal" class="modal" tabindex="-1" aria-labelledby="complaintModalLabel" data-bs-backdrop="static"

    data-bs-keyboard="false" aria-hidden="true" style="display: none;">

        <div class="modal-dialog">

            <div class="modal-content">

                <div class="modal-header">

                    <h5 class="modal-title" id="complaintModalLabel"></h5>

                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"> </button>

                </div>

                <div class="modal-body">

                    <form>

                        <input type="hidden" name="id" id="cs_id">

                        <!-- Tables Border Colors -->

                        <table class="table table-bordered border-secondary table-nowrap">

                            <tbody>

                                <tr>

                                    <th scope="row">Request ID : </th>

                                    <td>

                                        <span class="text-info" id="cs_request_id"></span>

                                    </td>

                                </tr>

                                <tr>

                                    <th scope="row">Date & Time :</th>

                                    <td>

                                        <span class="text-info" id="cs_created_at"></span>

                                    </td>

                                </tr>

                                <tr>

                                    <th scope="row">Status : </th>

                                    <td>

                                        <span class="text-info" id="cs_status"></span>

                                    </td>

                                </tr>

                                <tr>

                                    <th scope="row">Subject : </th>

                                    <td>

                                        <span class="text-info" id="cs_subject"></span>

                                    </td>

                                </tr>

                            </tbody>

                        </table>

                        <div class="mb-3">

                            <label>Remark : <span class="text-danger">*</span></label>

                            <textarea name="remark" id="cs_remark" class="form-control" required=""></textarea>

                        </div>

                        <div class="mb-3">

                            <label>Status : <span class="text-danger">*</span></label>

                            <select class="form-select mb-3 status" aria-label="Default select example" id="csu_status">

                                <option selected="">Select Status</option>

                                <option value="Under Review">Under Review</option>

                                <option value="Sloved">Sloved</option>

                                <option value="Closed">Closed</option>

                            </select>

                        </div>

                    </form>

                </div>

                <div class="modal-footer">

                    <button type="button" class="btn btn-light" data-bs-dismiss="modal">Close</button>

                    <button type="submit" class="btn btn-primary" id="complaint_now_btn" onclick="complaintSubmit()">Submit</button>

                </div>

            </div><!-- /.modal-content -->

        </div><!-- /.modal-dialog -->

    </div><!-- /.modal -->





      <!-- Edit Status Modals -->

   <div id="editStatusModal" class="modal" tabindex="-1" aria-labelledby="editStatusModalLabel" data-bs-backdrop="static"

    data-bs-keyboard="false" aria-hidden="true" style="display: none;">

        <div class="modal-dialog">

            <div class="modal-content">

                <div class="modal-header">

                    <h5 class="modal-title" id="editStatusModalLabel"></h5>

                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"> </button>

                </div>

                <div class="modal-body">

                    <form>

                        <input type="hidden" name="id" id="es_id">

                        <div class="mb-3">

                            <label>Operator Id : <span class="text-danger">*</span></label>

                            <input type="text" name="es_operator_id" id="es_operator_id" class="form-control" required="">

                        </div>

                        <div class="mb-3">

                            <label>Status : <span class="text-danger">*</span></label>

                            <select class="form-select mb-3 status" aria-label="Default select example" id="es_status">

                                

                            </select>

                        </div>

                    </form>

                </div>

                <div class="modal-footer">

                    <button type="button" class="btn btn-light" data-bs-dismiss="modal">Close</button>

                    <button type="submit" class="btn btn-primary" id="editStatus_now_btn" onclick="editStatusSubmit()">Submit</button>

                </div>

            </div><!-- /.modal-content -->

        </div><!-- /.modal-dialog -->

    </div><!-- /.modal -->





     <!-- Check Api Logs Details Modals -->

   <div id="checkApiLogModal" class="modal bs-example-modal-lg" tabindex="-1" aria-labelledby="checkApiLogModalLabel" data-bs-backdrop="static"

    data-bs-keyboard="false" aria-hidden="true" style="display: none;">

        <div class="modal-dialog modal-lg">

            <div class="modal-content">

                <div class="modal-header">

                    <h5 class="modal-title" id="checkApiLogModalLabel"></h5>

                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"> </button>

                </div>

                <div class="modal-body">

                        <table class="table table-bordered border-secondary table-nowrap" id="api_log_data">

                            

                        </table>

                </div>

                <div class="modal-footer">

                    <button type="button" class="btn btn-light" data-bs-dismiss="modal">Close</button>

                </div>

            </div><!-- /.modal-content -->

        </div><!-- /.modal-dialog -->

    </div><!-- /.modal -->



<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>

<script>

    var urlParams = new URLSearchParams(window.location.search);
    if(urlParams.has('status')){
       $("#status_name").val(urlParams.get('status')).change();
    }
    if(urlParams.has('complaint')){
       $("#complaint_id").val(urlParams.get('complaint')).change();
    }
    //alert(urlParams);

    $.ajax({

        url: '<?php echo e(route('rechargeGetAPis')); ?>',

        method: 'post',

        data: {_token: '<?php echo e(csrf_token()); ?>'},

        success: function(res) {

            //$('#user_list').show();

            console.log(res.data);

            

            $('#api_id').empty();

            htmlView = '<option selected value="0">All</option>';

            for(let i = 0; i < res.data.length; i++){

                htmlView += '<option value="'+res.data[i].id+'">'+res.data[i].api_name+'</option>';

            }

            $('#api_id').append(htmlView);

        }

    });

    fetchAllSearch(1,10);

    function tableSearch(page) {

        limit = $('#page_limit').val();

        page = page;

        fetchAllSearch(page,limit);

    }

    $(document).on('change','#page_limit',function(){

        page = 1;

        limit = $('#page_limit').val();

        fetchAllSearch(page,limit);

    });



    $(document).on('keyup','#searchValueTable',function(){

        var value = $( this ).val();

        if (this.value.length < 1) {

            $("#pagination_table tr").css("display", "");

        } else {

            $("#pagination_table tbody tr:not(:contains('"+this.value+"'))").css("display", "none");

            $("#pagination_table tbody tr:contains('"+this.value+"')").css("display", "");

        }

    })



    $(document).on('change','#service_id',function(){

        var service_id = $("#service_id").val();

        $.ajax({

            url: '<?php echo e(route('rechargeGetProvider')); ?>',

            method: 'post',

            data: {_token: '<?php echo e(csrf_token()); ?>',service_id},

            success: function(res) {

                //$('#user_list').show();

                console.log(res.data);

                

                $('#provider_id').empty();

                htmlView = '<option selected value="0">All</option>';

                for(let i = 0; i < res.data.length; i++){

                    htmlView += '<option value="'+res.data[i].id+'">'+res.data[i].provider_name+'</option>';

                }

                $('#provider_id').append(htmlView);

            }

        });

    });



    function fetchAllSearch(page, limit) {

        var from_date = $("#from_date").val();

        var to_date = $("#to_date").val();

        var tbl_type = $("#tbl_type").val();

        var user_id = $("#id_value").val();

        var order_id = $("#order_id").val();

        var number = $("#number_text").val();

        var service_id = $("#service_id").val();

        var provider_id = $("#provider_id").val();

        var api_id = $("#api_id").val();

        var status = $("#status_name").val();

        var complaint_id = $("#complaint_id").val();

        $("#search_btn").text('Wait...');

        $('#search_btn').prop('disabled', true);

        $("#list_result").html('<h4 class="text-center text-secondary my-3">Loading...</h4>');

        $.ajax({

            url: '<?php echo e(route('rechargeReportsList')); ?>',

            method: 'post',

            data: {

                from_date : from_date,

                to_date : to_date,

                tbl_type : tbl_type,

                user_id : user_id,

                order_id : order_id,

                number : number,

                complaint_id:complaint_id,

                service_id : service_id,

                provider_id : provider_id,

                api_id : api_id,

                status : status,

                page : page,

                limit : limit,

                _token: '<?php echo e(csrf_token()); ?>',

            },

            success: function(res) {

                $("#search_btn").text('Search');

                $('#search_btn').prop('disabled', false);

                $("#list_result").html(res);

            }

        });

    }



    $('#user_id').on('keyup', function(){

        $('#id_value').val("0");

        search();

    });



    function search(){

        var keyword = $('#user_id').val();

        $.ajax({

            url: '<?php echo e(route('rechargeSearchUuser')); ?>',

            method: 'post',

            data: {_token: '<?php echo e(csrf_token()); ?>',keyword:keyword},

            success: function(res) {

                $('#user_list').show();

                console.log(res);

                htmlView = "";

                //$('#user_list').empty();d

                for(let i = 0; i < res.users.length; i++){

                    htmlView += '<a onclick="selectValue(`'+res.users[i].id+'`,`'+res.users[i].outlet_name+' | '+res.users[i].first_name+' '+res.users[i].middle_name+' '+res.users[i].last_name+' | '+res.users[i].mobile_number+'`)">'+res.users[i].outlet_name+' | '+res.users[i].first_name+' '+res.users[i].middle_name+' '+res.users[i].last_name+' | '+res.users[i].mobile_number+'</a></br></hr>';

                }

                $('#user_list').html(htmlView);

            }

        });

    }



    function changeOperatorId(id){

        var operator_id = $('#input_operator_id_'+ id).val();

        $.ajax({

            url: '<?php echo e(route('changeOperatorId')); ?>',

            method: 'post',

            data: {_token: '<?php echo e(csrf_token()); ?>',id,operator_id},

            success: function(res) {

                if(res.error == 0){

                    

                    Error_Msg("success",res.error_msg,"success");

                }else{

                    Error_Msg("Oops...","Something went wrong!","error");

                }

                

            }

        });

    }



    function exportExcel() {

        var from_date = $("#from_date").val();

        var to_date = $("#to_date").val();

        var tbl_type = $("#tbl_type").val();

        var user_id = $("#id_value").val();

        var order_id = $("#order_id").val();

        var number = $("#number_text").val();

        var service_id = $("#service_id").val();

        var provider_id = $("#provider_id").val();

        var api_id = $("#api_id").val();

        var status = $("#status_name").val();

        $("#export_btn").text('Wait...');

        $('#export_btn').prop('disabled', true);

        //$("#list_result").html('<h4 class="text-center text-secondary my-3">Loading...</h4>');

        $.ajax({

            url: '<?php echo e(route('rechargeReportsListExport')); ?>',

            method: 'post',
            xhrFields: {
                responseType: 'blob'
            },
            data: {

                from_date : from_date,

                to_date : to_date,

                tbl_type : tbl_type,

                user_id : user_id,

                order_id : order_id,

                number : number,

                service_id : service_id,

                provider_id : provider_id,

                api_id : api_id,

                status : status,
                _token: '<?php echo e(csrf_token()); ?>',

            },

            success: function(response, status, xhr) {
                const filename = from_date+'_'+to_date+'_recharge_reports.csv'; // You can dynamically set the filename if needed
                const url = window.URL.createObjectURL(new Blob([response], { type: 'text/csv' }));
                const link = document.createElement('a');
                link.href = url;
                link.setAttribute('download', filename);
                document.body.appendChild(link);
                link.click();
                link.remove();
                $("#export_btn").text('Export Excel');
                $('#export_btn').prop('disabled', false);
            },
            error: function(xhr, status, error) {
                alert('Failed to export data to Excel.');
            }

        });

    }





    $(document).on('click', '.editComplaint', function(e) {

        e.preventDefault();

        let id = $(this).attr('id');

        $.ajax({

          url: '<?php echo e(route('getComplaint')); ?>',

          method: 'post',

          data: {

            id: id,

            _token: '<?php echo e(csrf_token()); ?>'

          },

          success: function(data) {

            if(data.error==0){

                $('#cs_request_id').text(data.data.request_id);

                $('#cs_created_at').text(data.data.created_at);

                $('#cs_status').text(data.data.status);

                $('#cs_subject').text(data.data.subject);

                $('#cs_id').val(data.data.id);

                $('#complaintModalLabel').text('Edit Complaint');

                $('#complaintModal').modal('show');

            }else{

                Error_Msg("Oops...",data.error_msg,"error");

            }

          },

          error: function( jqXhr, textStatus, errorThrown ){

            Error_Msg("Oops...","Something went wrong!","error");

         }

        });

    });





    function complaintSubmit() {

        var id = $("#cs_id").val();

        var remark = $("#cs_remark").val();

        var status = $("#csu_status").val();

        $("#complaint_now_btn").text('Please wait...');

        $('#complaint_now_btn').prop('disabled', true);

        $.ajax({

            url: '<?php echo e(route('updateComplaint')); ?>',

            method: 'post',

            data: {

                id,remark,status,

                _token: '<?php echo e(csrf_token()); ?>',

            },

            success: function(data) {

                $("#complaint_now_btn").text('Submit');

                $('#complaint_now_btn').prop('disabled', false);

                if(data.type == "success"){

                    $('#complaintModal').modal('hide');

                    Error_Msg(capitalizeFirstLetter(data.type), data.message, data.type);

                    fetchAllSearch(1,10);

                }else{

                    Error_Msg(capitalizeFirstLetter(data.type), data.message, data.type);

                }

            },

            error: function(err) {

                console.log(err);

                Error_Msg("Oops...", data.error_msg, "error");

                $("#complaint_now_btn").text('Submit');

                $('#complaint_now_btn').prop('disabled', false);

            }

        });

    }



   function editStatus(id,status,operator_id) {

        $('#es_status').empty();

        $('#es_id').val(id);

        $('#es_operator_id').val(operator_id);

        if(status == "Pending" || status == "Under Process"){

            $('#es_status').append('<option selected="">Select Status</option><option value="Success">Success</option><option value="Failed">Failed</option>');

        }else if(status == "Success"){

            $('#es_status').append('<option selected="">Select Status</option><option value="Refunded">Refunded</option');

        }else if(status == "Failed"){

            $('#es_status').append('<option selected="">Select Status</option><option value="Force Success">Force Success</option');

        }else{

            $('#es_status').append('<option selected="">Select Status</option>');

        }

        $('#editStatusModalLabel').text('Edit Status');

        $('#editStatusModal').modal('show');

    }



    function editStatusSubmit() {

        var id = $("#es_id").val();

        var operator_id = $("#es_operator_id").val();

        var status = $("#es_status").val();

        $("#editStatus_now_btn").text('Please wait...');

        $('#editStatus_now_btn').prop('disabled', true);

        $.ajax({

            url: '<?php echo e(route('updateStatus')); ?>',

            method: 'post',

            data: {

                id,operator_id,status,

                _token: '<?php echo e(csrf_token()); ?>',

            },

            success: function(data) {

                $("#editStatus_now_btn").text('Submit');

                $('#editStatus_now_btn').prop('disabled', false);

                if(data.type == "success"){

                    $('#editStatusModal').modal('hide');

                    Error_Msg(capitalizeFirstLetter(data.type), data.message, data.type);

                    fetchAllSearch(1,10);

                }else{

                    Error_Msg(capitalizeFirstLetter(data.type), data.message, data.type);

                }

            },

            error: function(err) {

                console.log(err);

                Error_Msg("Oops...", data.error_msg, "error");

                $("#editStatus_now_btn").text('Submit');

                $('#editStatus_now_btn').prop('disabled', false);

            }

        });

    }



    $(document).on('click', '.checkApilog', function(e) {

        e.preventDefault();

        let id = $(this).attr('id');

        $.ajax({

            url: '<?php echo e(route('checkApiLog')); ?>',

            method: 'post',

            data: {_token: '<?php echo e(csrf_token()); ?>',id},

            success: function(res) {

                if(res.type == "success"){

                    $('#api_log_data').empty();

                    htmlView_Api = '';

                    for(let i = 0; i < res.data.length; i++){

                        htmlView_Api += '<div style="border: 2px solid #865ce2;padding: 5px; border-radius: 11px;"><h6 style="color:blue;">API LOG : '+(i+1)+'</h6>'+

                            '<span>Order Id : </span>'+

                                '<p class="text-info">'+res.data[i].txnid+'</p>'+

                            '<span>Date & Time : </span>'+

                                '<p class="text-info">'+res.data[i].created_at+'</p>'+

                            '<span>Header : </span>'+

                                '<p class="text-info">'+res.data[i].header+'</p>'+

                            '<span>Type : </span>'+

                                '<p class="text-info">'+res.data[i].modal+'</p>'+

                            '<span>Post Data : </span>'+

                                '<p class="text-info">'+res.data[i].request+'</p>'+

                            '<span>Request URL : </span>'+

                                '<p class="text-info">'+res.data[i].url+'</p>'+

                            '<span>Response Data : </span>'+

                                '<p class="text-info">'+res.data[i].response+'</p>'+

                            '</div></br>';

                        $('#api_log_data').html(htmlView_Api);

                    }

                    $('#checkApiLogModalLabel').text('Api Logs');

                    $('#checkApiLogModal').modal('show');

                }else{

                    Error_Msg("Oops...", res.message, res.type);

                }

                //$('#user_list').show();

            }

        });

    });



    function selectValue(id,full_text) {

        $('#id_value').val(id);

        $('#user_id').val(full_text);

        $('#user_list').hide();

    }

</script>

<script src="https://code.jquery.com/jquery-3.6.0.min.js" integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>



<script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>

<script src="https://cdn.datatables.net/1.11.5/js/dataTables.bootstrap5.min.js"></script>

<script src="https://cdn.datatables.net/responsive/2.2.9/js/dataTables.responsive.min.js"></script>

<script src="https://cdn.datatables.net/buttons/2.2.2/js/dataTables.buttons.min.js"></script>

<script src="https://cdn.datatables.net/buttons/2.2.2/js/buttons.print.min.js"></script>

<script src="https://cdn.datatables.net/buttons/2.2.2/js/buttons.html5.min.js"></script>

<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>

<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>

<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>









<script src="<?php echo e(URL::asset('/assets/js/app.min.js')); ?>"></script>



<!--jquery cdn-->

<script src="https://code.jquery.com/jquery-3.6.0.min.js" integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>

<!--select2 cdn-->

<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

<script src="<?php echo e(URL::asset('/assets/js/pages/select2.init.js')); ?>">



<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u440912555/domains/topservicepoint.in/public_html/admin.topservicepoint.in/resources/views/admin/user-reports/recharge-report.blade.php ENDPATH**/ ?>