<?php




use Illuminate\Support\Facades\Mail;
use App\Mail\SendEmail;


use Illuminate\Support\Facades\Route;



use App\Http\Controllers\Admin\AuthController;



use App\Http\Controllers\Admin\DashboardController;



use App\Http\Controllers\Admin\SchemeController;



use App\Http\Controllers\Admin\BankController;



use App\Http\Controllers\Admin\RoleController;



use App\Http\Controllers\Admin\ServiceController;



use App\Http\Controllers\Admin\ProviderController;



use App\Http\Controllers\Admin\AnnouncementController;



use App\Http\Controllers\Admin\SliderController;



use App\Http\Controllers\Admin\ApiController;



use App\Http\Controllers\Admin\UserListController;



use App\Http\Middleware\AdminCheck;



use App\Http\Controllers\Admin\FundController;



use App\Http\Controllers\Admin\FundReportsController;



use App\Http\Controllers\Admin\AccountReportsController;



use App\Http\Controllers\Admin\RechargeReportsController;



use App\Http\Controllers\Admin\EmailTemplateController;



use App\Http\Controllers\Admin\SmsTemplateController;



use App\Http\Controllers\Admin\AdminReportsController;



use App\Http\Controllers\Admin\ComplaintController;



use App\Http\Controllers\Admin\ProfileController;



use App\Http\Controllers\Admin\CompanyController;



use App\Http\Controllers\Admin\AmountBlockController;

use App\Http\Controllers\Admin\AmountWizeSwitchController;

use App\Http\Controllers\Admin\StateWizeSwitchController;

use App\Http\Controllers\Admin\UserWizeSwitchController;

use App\Http\Controllers\Admin\RouteSettingController;








//use Illuminate\Support\Facades\



/*



|--------------------------------------------------------------------------



| Web Routes



|--------------------------------------------------------------------------



|



| Here is where you can register web routes for your application. These



| routes are loaded by the RouteServiceProvider within a group which



| contains the "web" middleware group. Now create something great!



|



*/



//Clear route cache

Route::get('/send-mail', function() {
    $subject = "Shiba";
    $message = "hii";
    //\Artisan::call('make:mail SendEmail');
    //\Artisan::call('queue:work');
   Mail::to('shibatechnology@gmail.com')->queue(new SendEmail($subject,$message));
});

Route::get('/optimize', function() {



    //\Artisan::call('vendor:publish --tag=datatables');



    



    //\Artisan::call('make:mail SendEmail');



    \Artisan::call('route:cache');



    \Artisan::call('config:cache');



    \Artisan::call('cache:clear');



    \Artisan::call('view:clear');



    \Artisan::call('optimize:clear');



    return 'software optimize';



});



Route::get('/', function () {



    //return view('welcome');

    

    return Redirect::route('loginPage');



});

Route::get('/clear-login', function () {

    Session::flush();

    return Redirect::route('loginPage');

});





//Admin Portal Routes 



Route::get('admin/login',[AuthController::class,'Login'])->name('loginPage');



Route::post('admin/login-check',[AuthController::class,'LoginCheck'])->name('LoginCheck');



Route::post('admin/check-otp-login',[AuthController::class,'checkLoginOtp'])->name('checkLoginOtp');



Route::get('admin/forgot-password',[AuthController::class,'forgotPassword'])->name('forgotPassword');



Route::post('admin/send-otp-forgot-password',[AuthController::class,'sendOtpForgotPassword'])->name('sendOtpForgotPassword');



Route::post('admin/verify-otp-forgot-password',[AuthController::class,'verifyOtpForgotPassword'])->name('verifyOtpForgotPassword');



//Admin Portal Routes AdminCheck(middleware)



Route::group(['middleware' => AdminCheck::class], function () {



    Route::get('admin/logout',[AuthController::class,'Logout'])->name('adminLogout');



    Route::get('admin/dashboard', [DashboardController::class, 'Dashboard']);



    Route::post('admin/dashboard/load-wallet',[DashboardController::class,'adminLoadWallet'])->name('adminLoadWallet');



    Route::post('admin/dashboard/report-data',[DashboardController::class,'dashboardReportsList'])->name('dashboardReportsList');

    Route::post('admin/dashboard/top-bar-data',[DashboardController::class,'topbarCount'])->name('topbarCount');



    //My Profile Routes 



    Route::get('admin/profile/my-profile',[ProfileController::class,'myProfile'])->name('myProfile');



    Route::post('admin/profile/my-profile-data',[ProfileController::class,'myProfileData'])->name('myProfileData');



    Route::post('admin/profile/my-profile-password-change',[ProfileController::class,'myProfilePasswordChange'])->name('myProfilePasswordChange');



    //Scheme Routes 



    Route::get('admin/system/scheme',[SchemeController::class,'index']);



    Route::post('admin/system/scheme/list',[SchemeController::class,'fetchAll'])->name('schemeList');



    Route::post('admin/system/scheme/delete',[SchemeController::class,'deleteData'])->name('schemeDelete');



    Route::post('admin/system/scheme/get',[SchemeController::class,'getData'])->name('schemeGet');



    Route::post('admin/system/scheme/update',[SchemeController::class,'updateData'])->name('schemeUpdate');



    Route::post('admin/system/scheme/commission',[SchemeController::class,'getCommissionData'])->name('schemeGetCommission');



    Route::post('admin/system/scheme/single_set_commission',[SchemeController::class,'SingleUpdateCommission'])->name('schemeSingleUpdateCommission');



    Route::post('admin/system/scheme/bulk_set_commission',[SchemeController::class,'BulkUpdateCommission'])->name('schemeBulkUpdateCommission');



    //Bank Routes 



    Route::get('admin/system/banks',[BankController::class,'index']);



    Route::post('admin/system/banks/list',[BankController::class,'fetchAll'])->name('bankList');



    Route::post('admin/system/banks/delete',[BankController::class,'deleteData'])->name('bankDelete');



    Route::post('admin/system/banks/get',[BankController::class,'getData'])->name('bankGet');



    Route::post('admin/system/banks/update',[BankController::class,'updateData'])->name('bankUpdate');



    //Amount Block



    Route::get('admin/system/amount-block',[AmountBlockController::class,'index']);



    Route::post('admin/system/amount-block/list',[AmountBlockController::class,'fetchAll'])->name('amountBlockList');



    Route::post('admin/system/amount-block/get',[AmountBlockController::class,'getData'])->name('amountBlockGet');



    Route::post('admin/system/amount-block/update',[AmountBlockController::class,'updateData'])->name('amountBlockUpdate');



    Route::post('admin/system/amount-block/delete',[AmountBlockController::class,'deleteData'])->name('amountBlockDelete');

    //Amount Wize Switch

    Route::get('admin/system/amount-wize-switch',[AmountWizeSwitchController::class,'index']);



    Route::post('admin/system/amount-wize-switch/list',[AmountWizeSwitchController::class,'fetchAll'])->name('amountWizeSwitchList');



    Route::post('admin/system/amount-wize-switch/get',[AmountWizeSwitchController::class,'getData'])->name('amountWizeSwitchGet');



    Route::post('admin/system/amount-wize-switch/update',[AmountWizeSwitchController::class,'updateData'])->name('amountWizeSwitchUpdate');



    Route::post('admin/system/amount-wize-switch/delete',[AmountWizeSwitchController::class,'deleteData'])->name('amountWizeSwitchDelete');

    //State Wize Switch

    Route::get('admin/system/state-wize-switch',[StateWizeSwitchController::class,'index']);


    Route::post('admin/system/state-wize-switch/list',[StateWizeSwitchController::class,'fetchAll'])->name('stateWizeSwitchList');


    Route::post('admin/system/state-wize-switch/get',[StateWizeSwitchController::class,'getData'])->name('stateWizeSwitchGet');


    Route::post('admin/system/state-wize-switch/update',[StateWizeSwitchController::class,'updateData'])->name('stateWizeSwitchUpdate');


    Route::post('admin/system/state-wize-switch/delete',[StateWizeSwitchController::class,'deleteData'])->name('stateWizeSwitchDelete');


    //User Wize Switch

    Route::get('admin/system/user-wize-switch',[UserWizeSwitchController::class,'index']);

    Route::post('admin/system/user-wize-switch/list',[UserWizeSwitchController::class,'fetchAll'])->name('userWizeSwitchList');

    Route::post('admin/system/user-wize-switch/get',[UserWizeSwitchController::class,'getData'])->name('userWizeSwitchGet');

    Route::post('admin/system/user-wize-switch/update',[UserWizeSwitchController::class,'updateData'])->name('userWizeSwitchUpdate');

    Route::post('admin/system/user-wize-switch/delete',[UserWizeSwitchController::class,'deleteData'])->name('userWizeSwitchDelete');
    //Role Routes 



    Route::get('admin/system/role',[RoleController::class,'index']);



    Route::post('admin/system/role/list',[RoleController::class,'fetchAll'])->name('roleList');



    



    //Service Routes 



    Route::get('admin/system/services',[ServiceController::class,'index']);



    Route::post('admin/system/services/list',[ServiceController::class,'fetchAll'])->name('servicesList');



    //Provider Routes 



    Route::get('admin/system/providers',[ProviderController::class,'index']);



    Route::post('admin/system/providers/list',[ProviderController::class,'fetchAll'])->name('providersList');



    Route::post('admin/system/providers/delete',[ProviderController::class,'deleteData'])->name('providersDelete');



    Route::post('admin/system/providers/get',[ProviderController::class,'getData'])->name('providersGet');



    Route::post('admin/system/providers/api_and_service',[ProviderController::class,'getDataService'])->name('apiAndService');



    Route::post('admin/system/providers/update',[ProviderController::class,'updateData'])->name('providersUpdate');



    //Announcement Routes 



    Route::get('admin/system/announcement',[AnnouncementController::class,'index']);



    Route::post('admin/system/announcement/update',[AnnouncementController::class,'updateData'])->name('announcementUpdate');



    Route::post('admin/system/announcement/get',[AnnouncementController::class,'getData'])->name('announcementGet');



    //Slider Routes 



    Route::get('admin/system/slider',[SliderController::class,'index']);



    Route::post('admin/system/slider/list',[SliderController::class,'fetchAll'])->name('sliderList');



    Route::post('admin/system/slider/delete',[SliderController::class,'deleteData'])->name('sliderDelete');



    Route::post('admin/system/slider/get',[SliderController::class,'getData'])->name('sliderGet');



    Route::post('admin/system/slider/update',[SliderController::class,'updateData'])->name('sliderUpdate');



    //Api Routes 



    Route::get('admin/system/apis',[ApiController::class,'index']);



    Route::post('admin/system/apis/list',[ApiController::class,'fetchAll'])->name('apisList');



    Route::post('admin/system/apis/delete',[ApiController::class,'deleteData'])->name('apisDelete');



    Route::post('admin/system/apis/get',[ApiController::class,'getData'])->name('apisGet');



    Route::post('admin/system/apis/update',[ApiController::class,'updateData'])->name('apisUpdate');



    Route::post('admin/system/apis/check-live-balance',[ApiController::class,'CheckLiveBalance'])->name('apisCheckLiveBalance');



    Route::post('admin/system/apis/provider-code',[ApiController::class,'getProviderCodeData'])->name('apisGetProviderCode');



    Route::post('admin/system/apis/single-set-provider-code',[ApiController::class,'SingleUpdateProviderCode'])->name('apisSingleUpdateProviderCode');



    Route::post('admin/system/apis/bulk-set-provider-code',[ApiController::class,'BulkUpdateProviderCode'])->name('apisBulkUpdateProviderCode');



    Route::post('admin/system/apis/state-code',[ApiController::class,'getStateCodeData'])->name('apisGetStateCode');

    Route::post('admin/system/apis/single-set-state-code',[ApiController::class,'SingleUpdateStateCode'])->name('apisSingleUpdateStateCode');


    Route::post('admin/system/apis/bulk-set-state-code',[ApiController::class,'BulkUpdateStateCode'])->name('apisBulkUpdateStateCode');



    //User List Routes 



    Route::get('admin/users/list',[UserListController::class,'index']);



    Route::post('admin/users/userlist/list',[UserListController::class,'fetchAll'])->name('userlistList');



    Route::post('admin/users/userlist/parent-list',[UserListController::class,'parentListSearchUuser'])->name('parentListSearchUuser');



    Route::post('admin/users/userlist/delete',[UserListController::class,'deleteData'])->name('userlistDelete');



    Route::post('admin/users/userlist/get',[UserListController::class,'getData'])->name('userlistGet');



    Route::post('admin/users/userlist/update',[UserListController::class,'updateData'])->name('userlistUpdate');



    Route::post('admin/users/userlist/fundupdate',[UserListController::class,'fundUpdate'])->name('fundUpdate');



    Route::post('admin/users/userlist/resetpassword',[UserListController::class,'resetPassword'])->name('resetPassword');



    Route::post('admin/users/userlist/resetPIN',[UserListController::class,'resetPIN'])->name('resetPIN');



    //Send Message Routes 



    Route::get('admin/users/send-message',[UserListController::class,'sendMessage']);



    Route::post('admin/users/send-message-users',[UserListController::class,'sendMessageUsers'])->name('sendMessageUsers');



    //Fund Request Routes 



    Route::get('admin/fund/fund-request',[FundController::class,'index']);



    Route::post('admin/fund/fund-request/list',[FundController::class,'fetchAll'])->name('fundRequestList');



    Route::post('admin/fund/fund-request/search_user',[FundController::class,'searchUuser'])->name('fundRequestSearchUser');



    Route::post('admin/fund/fund-request/update',[FundController::class,'updateData'])->name('fundRequestUpdate');



    //Fund Reports Routes 



    Route::get('admin/fund/fund-report',[FundReportsController::class,'index']);



    Route::post('admin/fund/fund-report/list',[FundReportsController::class,'fetchAll'])->name('fundReportsList');

    Route::post('admin/fund/fund-report/export',[FundReportsController::class,'fetchAllExport'])->name('fundReportsListExport');



    Route::post('admin/fund/fund-report/search_user',[FundReportsController::class,'searchUuser'])->name('fundsearchUuser');



    //Account Reports Routes 



    Route::get('admin/user-reports/account-report',[AccountReportsController::class,'index']);



    Route::post('admin/user-reports/account-report/list',[AccountReportsController::class,'fetchAll'])->name('accountReportsList');

    Route::post('admin/user-reports/account-report/export',[AccountReportsController::class,'fetchAllExport'])->name('accountReportsExport');



    Route::post('admin/user-reports/account-report/search_user',[AccountReportsController::class,'searchUuser'])->name('accountsearchUuser');



    //Recharge Reports Routes 



    Route::get('admin/user-reports/recharge-report',[RechargeReportsController::class,'index']);



    Route::post('admin/user-reports/recharge-report/list',[RechargeReportsController::class,'fetchAll'])->name('rechargeReportsList');

  

  	Route::post('admin/user-reports/recharge-report/export',[RechargeReportsController::class,'fetchAllExport'])->name('rechargeReportsListExport');



    Route::post('admin/user-reports/recharge-report/search_user',[RechargeReportsController::class,'searchUuser'])->name('rechargeSearchUuser');



    Route::post('admin/user-reports/recharge-report/get-provider',[RechargeReportsController::class,'getProvider'])->name('rechargeGetProvider');



    Route::post('admin/user-reports/recharge-report/get-apis',[RechargeReportsController::class,'getApis'])->name('rechargeGetAPis');



    Route::post('admin/user-reports/recharge-report/change-operator-id',[RechargeReportsController::class,'changeOperatorId'])->name('changeOperatorId');



    Route::post('admin/user-reports/recharge-report/get-complaint',[RechargeReportsController::class,'getComplaint'])->name('getComplaint');



    Route::post('admin/user-reports/recharge-report/update-complaint',[RechargeReportsController::class,'updateComplaint'])->name('updateComplaint');



    Route::post('admin/user-reports/recharge-report/update-status',[RechargeReportsController::class,'updateStatus'])->name('updateStatus');



    Route::post('admin/user-reports/recharge-report/check-api-logs',[RechargeReportsController::class,'checkApiLog'])->name('checkApiLog');



    //Manage Company Routes 



    Route::get('admin/company/manage-company',[CompanyController::class,'index']);



    Route::post('admin/company/manage-company/list',[CompanyController::class,'fetchAll'])->name('manageCompanyList');



    Route::post('admin/company/manage-company/get',[CompanyController::class,'getData'])->name('manageCompanyGet');



    Route::post('admin/company/manage-company/update',[CompanyController::class,'updateData'])->name('manageCompanyUpdate');



    //Email Template Routes 



    Route::get('admin/company/email-template',[EmailTemplateController::class,'index']);



    Route::post('admin/company/email-template/list',[EmailTemplateController::class,'fetchAll'])->name('emailTemplateList');



    Route::post('admin/company/email-template/delete',[EmailTemplateController::class,'deleteData'])->name('emailTemplateDelete');



    Route::post('admin/company/email-template/get',[EmailTemplateController::class,'getData'])->name('emailTemplateGet');



    Route::post('admin/company/email-template/update',[EmailTemplateController::class,'updateData'])->name('emailTemplateUpdate');



    //SMS Template Routes 



    Route::get('admin/company/sms-template',[SmsTemplateController::class,'index']);



    Route::post('admin/company/sms-template/list',[SmsTemplateController::class,'fetchAll'])->name('smsTemplateList');



    Route::post('admin/company/sms-template/delete',[SmsTemplateController::class,'deleteData'])->name('smsTemplateDelete');



    Route::post('admin/company/sms-template/get',[SmsTemplateController::class,'getData'])->name('smsTemplateGet');



    Route::post('admin/company/sms-template/update',[SmsTemplateController::class,'updateData'])->name('smsTemplateUpdate');

    ///Routes Settings

    Route::get('admin/company/routes-settings',[RouteSettingController::class,'index']);


    Route::post('admin/company/routes-settings/list',[RouteSettingController::class,'fetchAll'])->name('routeSettingsList');

    Route::post('admin/company/routes-settings/update-priority',[RouteSettingController::class,'routesBulkUpdatePriority'])->name('routesBulkUpdatePriority');



    //Live Recharge Reports Routes



    Route::get('admin/admin-reports/recharge-live-reports',[AdminReportsController::class,'liveRechargeReports']);



    Route::post('admin/admin-reports/recharge-live-reports/list',[AdminReportsController::class,'liveRechargeReportsList'])->name('liveRechargeReportsList');



    //User Sale Reports Routes



    Route::get('admin/admin-reports/user-sale-report',[AdminReportsController::class,'userSaleReports']);


    Route::post('admin/admin-reports/user-sale-report/list',[AdminReportsController::class,'userSaleReportsList'])->name('userSaleReportsList');


    //Md And Dt Sale Reports Routes
    Route::get('admin/admin-reports/md-dt-sale-report',[AdminReportsController::class,'mdAndDtSaleReports']);

    Route::post('admin/admin-reports/md-dt-sale-report/list',[AdminReportsController::class,'mdAndDtSaleReportsList'])->name('mdAndDtSaleReportsList');



    //Provider Sale Reports Routes



    Route::get('admin/admin-reports/provider-sale-report',[AdminReportsController::class,'providerSaleReports']);



    Route::post('admin/admin-reports/provider-sale-report/list',[AdminReportsController::class,'providerSaleReportsList'])->name('providerSaleReportsList');



    //Provider Sale Reports Routes



    Route::get('admin/admin-reports/api-sale-report',[AdminReportsController::class,'apiSaleReports']);



    Route::post('admin/admin-reports/api-list',[AdminReportsController::class,'apiList'])->name('apiList');



    Route::post('admin/admin-reports/api-sale-report/list',[AdminReportsController::class,'apiSaleReportsList'])->name('apiSaleReportsList');



    //Api Log Reports Routes



    Route::get('admin/admin-reports/api-log-report',[AdminReportsController::class,'apiLogReports']);



    Route::post('admin/admin-reports/api-log-report/list',[AdminReportsController::class,'apiLogReportsList'])->name('apiLogReportsList');



    //Complaints Routes



    Route::get('admin/support/complaint',[ComplaintController::class,'index']);



    Route::post('admin/support/complaint/list',[ComplaintController::class,'fetchAll'])->name('ComplaintsList');



    Route::post('admin/support/complaint/get-report',[ComplaintController::class,'getReport'])->name('ComplaintsGetReport');







});































