/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova.engine;

import android.content.ActivityNotFoundException;
import android.content.ClipData;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Parcelable;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.GeolocationPermissions;
import android.webkit.JsPromptResult;
import android.webkit.JsResult;
import android.webkit.PermissionRequest;
import android.webkit.ValueCallback;
import android.webkit.WebChromeClient;
import android.webkit.WebStorage;
import android.webkit.WebView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import androidx.core.content.FileProvider;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.cordova.CordovaDialogsHelper;
import org.apache.cordova.CordovaPlugin;
import org.apache.cordova.LOG;
import org.apache.cordova.engine.SystemWebViewEngine;

public class SystemWebChromeClient
extends WebChromeClient {
    private static final int FILECHOOSER_RESULTCODE = 5173;
    private static final String LOG_TAG = "SystemWebChromeClient";
    private long MAX_QUOTA = 0x6400000L;
    protected final SystemWebViewEngine parentEngine;
    private View mVideoProgressView;
    private CordovaDialogsHelper dialogsHelper;
    private Context appContext;
    private WebChromeClient.CustomViewCallback mCustomViewCallback;
    private View mCustomView;

    public SystemWebChromeClient(SystemWebViewEngine parentEngine) {
        this.parentEngine = parentEngine;
        this.appContext = parentEngine.webView.getContext();
        this.dialogsHelper = new CordovaDialogsHelper(this.appContext);
    }

    public boolean onJsAlert(WebView view, String url, String message, final JsResult result) {
        this.dialogsHelper.showAlert(message, new CordovaDialogsHelper.Result(){

            @Override
            public void gotResult(boolean success, String value) {
                if (success) {
                    result.confirm();
                } else {
                    result.cancel();
                }
            }
        });
        return true;
    }

    public boolean onJsConfirm(WebView view, String url, String message, final JsResult result) {
        this.dialogsHelper.showConfirm(message, new CordovaDialogsHelper.Result(){

            @Override
            public void gotResult(boolean success, String value) {
                if (success) {
                    result.confirm();
                } else {
                    result.cancel();
                }
            }
        });
        return true;
    }

    public boolean onJsPrompt(WebView view, String origin, String message, String defaultValue, final JsPromptResult result) {
        String handledRet = this.parentEngine.bridge.promptOnJsPrompt(origin, message, defaultValue);
        if (handledRet != null) {
            result.confirm(handledRet);
        } else {
            this.dialogsHelper.showPrompt(message, defaultValue, new CordovaDialogsHelper.Result(){

                @Override
                public void gotResult(boolean success, String value) {
                    if (success) {
                        result.confirm(value);
                    } else {
                        result.cancel();
                    }
                }
            });
        }
        return true;
    }

    public void onExceededDatabaseQuota(String url, String databaseIdentifier, long currentQuota, long estimatedSize, long totalUsedQuota, WebStorage.QuotaUpdater quotaUpdater) {
        LOG.d(LOG_TAG, "onExceededDatabaseQuota estimatedSize: %d  currentQuota: %d  totalUsedQuota: %d", estimatedSize, currentQuota, totalUsedQuota);
        quotaUpdater.updateQuota(this.MAX_QUOTA);
    }

    public void onGeolocationPermissionsShowPrompt(String origin, GeolocationPermissions.Callback callback) {
        super.onGeolocationPermissionsShowPrompt(origin, callback);
        callback.invoke(origin, true, false);
        CordovaPlugin geolocation = this.parentEngine.pluginManager.getPlugin("Geolocation");
        if (geolocation != null && !geolocation.hasPermisssion()) {
            geolocation.requestPermissions(0);
        }
    }

    public void onShowCustomView(View view, WebChromeClient.CustomViewCallback callback) {
        this.parentEngine.getCordovaWebView().showCustomView(view, callback);
    }

    public void onHideCustomView() {
        this.parentEngine.getCordovaWebView().hideCustomView();
    }

    public View getVideoLoadingProgressView() {
        if (this.mVideoProgressView == null) {
            LinearLayout layout = new LinearLayout(this.parentEngine.getView().getContext());
            layout.setOrientation(1);
            RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
            layoutParams.addRule(13);
            layout.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            ProgressBar bar = new ProgressBar(this.parentEngine.getView().getContext());
            LinearLayout.LayoutParams barLayoutParams = new LinearLayout.LayoutParams(-2, -2);
            barLayoutParams.gravity = 17;
            bar.setLayoutParams((ViewGroup.LayoutParams)barLayoutParams);
            layout.addView((View)bar);
            this.mVideoProgressView = layout;
        }
        return this.mVideoProgressView;
    }

    public boolean onShowFileChooser(WebView webView, final ValueCallback<Uri[]> filePathsCallback, WebChromeClient.FileChooserParams fileChooserParams) {
        Intent fileIntent = fileChooserParams.createIntent();
        Boolean selectMultiple = false;
        if (fileChooserParams.getMode() == 1) {
            selectMultiple = true;
        }
        fileIntent.putExtra("android.intent.extra.ALLOW_MULTIPLE", (Serializable)selectMultiple);
        String[] acceptTypes = fileChooserParams.getAcceptTypes();
        if (acceptTypes.length > 1) {
            fileIntent.setType("*/*");
            fileIntent.putExtra("android.intent.extra.MIME_TYPES", acceptTypes);
        }
        Uri tempUri = null;
        Intent captureIntent = null;
        if (fileChooserParams.isCaptureEnabled()) {
            captureIntent = new Intent("android.media.action.IMAGE_CAPTURE");
            Context context = this.parentEngine.getView().getContext();
            if (context.getPackageManager().hasSystemFeature("android.hardware.camera.any") && captureIntent.resolveActivity(context.getPackageManager()) != null) {
                try {
                    File tempFile = this.createTempFile(context);
                    LOG.d(LOG_TAG, "Temporary photo capture file: " + tempFile);
                    tempUri = this.createUriForFile(context, tempFile);
                    LOG.d(LOG_TAG, "Temporary photo capture URI: " + tempUri);
                    captureIntent.putExtra("output", (Parcelable)tempUri);
                }
                catch (IOException e) {
                    LOG.e(LOG_TAG, "Unable to create temporary file for photo capture", e);
                    captureIntent = null;
                }
            } else {
                LOG.w(LOG_TAG, "Device does not support photo capture");
                captureIntent = null;
            }
        }
        final Uri captureUri = tempUri;
        Intent chooserIntent = Intent.createChooser((Intent)fileIntent, null);
        if (captureIntent != null) {
            chooserIntent.putExtra("android.intent.extra.INITIAL_INTENTS", (Parcelable[])new Intent[]{captureIntent});
        }
        try {
            LOG.i(LOG_TAG, "Starting intent for file chooser");
            this.parentEngine.cordova.startActivityForResult(new CordovaPlugin(){

                @Override
                public void onActivityResult(int requestCode, int resultCode, Intent intent) {
                    Uri[] result = null;
                    if (resultCode == -1) {
                        ArrayList<Uri> uris = new ArrayList<Uri>();
                        if (intent != null && intent.getData() != null) {
                            LOG.v(SystemWebChromeClient.LOG_TAG, "Adding file (single): " + intent.getData());
                            uris.add(intent.getData());
                        } else if (captureUri != null) {
                            LOG.v(SystemWebChromeClient.LOG_TAG, "Adding camera capture: " + captureUri);
                            uris.add(captureUri);
                        } else if (intent != null && intent.getClipData() != null) {
                            ClipData clipData = intent.getClipData();
                            int count = clipData.getItemCount();
                            for (int i = 0; i < count; ++i) {
                                Uri uri = clipData.getItemAt(i).getUri();
                                LOG.v(SystemWebChromeClient.LOG_TAG, "Adding file (multiple): " + uri);
                                if (uri == null) continue;
                                uris.add(uri);
                            }
                        }
                        if (!uris.isEmpty()) {
                            LOG.d(SystemWebChromeClient.LOG_TAG, "Receive file chooser URL: " + ((Object)uris).toString());
                            result = uris.toArray(new Uri[uris.size()]);
                        }
                    }
                    filePathsCallback.onReceiveValue(result);
                }
            }, chooserIntent, 5173);
        }
        catch (ActivityNotFoundException e) {
            LOG.w(LOG_TAG, "No activity found to handle file chooser intent.", e);
            filePathsCallback.onReceiveValue(null);
        }
        return true;
    }

    private File createTempFile(Context context) throws IOException {
        File tempFile = File.createTempFile("temp", ".jpg", context.getCacheDir());
        return tempFile;
    }

    private Uri createUriForFile(Context context, File tempFile) throws IOException {
        String appId = context.getPackageName();
        Uri uri = FileProvider.getUriForFile((Context)context, (String)(appId + ".cdv.core.file.provider"), (File)tempFile);
        return uri;
    }

    public void onPermissionRequest(PermissionRequest request) {
        LOG.d(LOG_TAG, "onPermissionRequest: " + Arrays.toString(request.getResources()));
        request.grant(request.getResources());
    }

    public void destroyLastDialog() {
        this.dialogsHelper.destroyLastDialog();
    }
}

