/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.annotation.SuppressLint;
import android.os.Handler;
import android.view.View;
import android.view.animation.AccelerateInterpolator;
import androidx.annotation.NonNull;
import androidx.core.splashscreen.SplashScreen;
import androidx.core.splashscreen.SplashScreenViewProvider;
import org.apache.cordova.CallbackContext;
import org.apache.cordova.CordovaPlugin;
import org.apache.cordova.LOG;
import org.json.JSONArray;
import org.json.JSONException;

@SuppressLint(value={"LongLogTag"})
public class SplashScreenPlugin
extends CordovaPlugin {
    static final String PLUGIN_NAME = "CordovaSplashScreenPlugin";
    private static final boolean DEFAULT_AUTO_HIDE = true;
    private static final int DEFAULT_DELAY_TIME = -1;
    private static final boolean DEFAULT_FADE = true;
    private static final int DEFAULT_FADE_TIME = 500;
    private boolean autoHide;
    private int delayTime;
    private boolean isFadeEnabled;
    private int fadeDuration;
    private boolean keepOnScreen = true;

    @Override
    protected void pluginInitialize() {
        this.autoHide = this.preferences.getBoolean("AutoHideSplashScreen", true);
        this.delayTime = this.preferences.getInteger("SplashScreenDelay", -1);
        LOG.d(PLUGIN_NAME, "Auto Hide: " + this.autoHide);
        if (this.delayTime != -1) {
            LOG.d(PLUGIN_NAME, "Delay: " + this.delayTime + "ms");
        }
        this.isFadeEnabled = this.preferences.getBoolean("FadeSplashScreen", true);
        this.fadeDuration = this.preferences.getInteger("FadeSplashScreenDuration", 500);
        LOG.d(PLUGIN_NAME, "Fade: " + this.isFadeEnabled);
        if (this.isFadeEnabled) {
            LOG.d(PLUGIN_NAME, "Fade Duration: " + this.fadeDuration + "ms");
        }
    }

    @Override
    public boolean execute(String action, JSONArray args, CallbackContext callbackContext) throws JSONException {
        if (!action.equals("hide") || this.autoHide) {
            return false;
        }
        this.keepOnScreen = false;
        callbackContext.success();
        return true;
    }

    @Override
    public Object onMessage(String id, Object data) {
        switch (id) {
            case "setupSplashScreen": {
                this.setupSplashScreen((SplashScreen)data);
                break;
            }
            case "onPageFinished": {
                this.attemptCloseOnPageFinished();
            }
        }
        return null;
    }

    private void setupSplashScreen(SplashScreen splashScreen) {
        splashScreen.setKeepOnScreenCondition(() -> this.keepOnScreen);
        if (this.autoHide && this.delayTime != -1) {
            Handler splashScreenDelayHandler = new Handler(this.cordova.getContext().getMainLooper());
            splashScreenDelayHandler.postDelayed(() -> {
                this.keepOnScreen = false;
            }, (long)this.delayTime);
        }
        if (this.isFadeEnabled) {
            splashScreen.setOnExitAnimationListener(new SplashScreen.OnExitAnimationListener(){

                public void onSplashScreenExit(final @NonNull SplashScreenViewProvider splashScreenViewProvider) {
                    View splashScreenView = splashScreenViewProvider.getView();
                    splashScreenView.animate().alpha(0.0f).setDuration((long)SplashScreenPlugin.this.fadeDuration).setStartDelay(0L).setInterpolator((TimeInterpolator)new AccelerateInterpolator()).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                        public void onAnimationEnd(Animator animation) {
                            super.onAnimationEnd(animation);
                            splashScreenViewProvider.remove();
                        }
                    }).start();
                }
            });
        }
    }

    private void attemptCloseOnPageFinished() {
        if (this.autoHide && this.delayTime == -1) {
            this.keepOnScreen = false;
        }
    }
}

